// Content script for Context Capsule browser extension
// This script runs on all pages and can extract content when requested

(function() {
  // Listen for messages from the popup
  chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'getPageContent') {
      const content = extractPageContent();
      sendResponse(content);
    }
    return true;
  });
  
  function extractPageContent() {
    // Try to find the main content area
    const article = document.querySelector('article');
    const main = document.querySelector('main');
    const content = article || main || document.body;
    
    // Clone and clean the content
    const cloned = content.cloneNode(true);
    
    // Remove non-content elements
    const removeSelectors = [
      'script', 'style', 'nav', 'header', 'footer', 'aside',
      'iframe', 'noscript', '.ad', '.ads', '.advertisement',
      '[role="navigation"]', '[role="banner"]', '[role="contentinfo"]',
      '.sidebar', '.menu', '.comments', '.social-share'
    ];
    
    removeSelectors.forEach(selector => {
      cloned.querySelectorAll(selector).forEach(el => el.remove());
    });
    
    // Get metadata
    const title = document.title;
    const url = window.location.href;
    const description = document.querySelector('meta[name="description"]')?.content || 
                       document.querySelector('meta[property="og:description"]')?.content || '';
    const author = document.querySelector('meta[name="author"]')?.content ||
                  document.querySelector('[rel="author"]')?.textContent || '';
    const publishedDate = document.querySelector('meta[property="article:published_time"]')?.content ||
                         document.querySelector('time[datetime]')?.getAttribute('datetime') || '';
    
    // Get clean text content (limit to 50KB)
    const textContent = cloned.innerText
      .replace(/\s+/g, ' ')
      .trim()
      .substring(0, 50000);
    
    return {
      title,
      url,
      description,
      author,
      publishedDate,
      content: textContent
    };
  }
})();
